//
//  Brilliant Cut.js
//  (c) 2006 Hiroto Tsubaki
//  http://www.tres-graficos.jp/
//  tg@tres-graficos.jp
//
// modified at 2006-01-10 : bug fix
// modified at 2006-01-11 : add girdle, culet, and set default button.

function setDepthDefault(obj) {

    var doc = obj.document();
    
    //print("setDepthDefault-------");
    
    doc.retainRedrawLock();
    
    obj.setParameter("depth of table", 0.52);
    obj.setParameter("depth of girdle", 0.025);
    obj.setParameter("depth", 0.592);
    obj.setParameter("depth of pavilion", 0.42);
    
    doc.releaseRedrawLock();
    
    obj.update();
}

function buildUI(obj){
    obj.setParameter("name","Brilliant Cut");
    
    obj.addParameterFloat("round",1,0,500,true,true);
    obj.addParameterFloat("depth", 0.592, 0.3, 2.0, true, true);
    obj.addParameterFloat("depth of pavilion",0.42,0.1,0.8,true,true);
    obj.addParameterFloat("depth of table", 0.52, 0.25, 0.65, true, true);
    obj.addParameterFloat("depth of girdle", 0.025, 0, 0.03, true, true);
    obj.addParameterBool("culet face", 0, 0, 1, true, true);
    
    obj.addParameterSeparator("Set default");
    obj.addParameterButton("default depth values", "set", "setDepthDefault");
    
    // if you want to add Smooth Menu..
    //    normalType means 0 - flat, 1 - constraint, 2 - phong
    /*
    obj.addParameterSeparator("Smooth");
    obj.addParameterInt("normalType", 0,0,2,true,true);
    obj.addParameterFloat("normalAngle", 45.0, 5.0, 90.0, true, true);
    */
    
    obj.setParameter("normalType",0);
}

function buildObject(obj){
    var core = obj.core();

    var i;

    var x = new Array;
    var y = new Array;
    var z = new Array;
    var tableVerts = new Array;
    var starVerts = new Array;
    var bezelVerts = new Array;
    var edgeVerts = new Array;
    var lowerVerts = new Array;
    var mainVerts = new Array;
    
    baseRound = obj.getParameter("round");
    depthTable = obj.getParameter("depth of table");
    depthGirdle = obj.getParameter("depth of girdle");
    depth = obj.getParameter("depth");
    depthPavilion = obj.getParameter("depth of pavilion");
    culetFace = obj.getParameter("culet face");
        
    core.buildVertexBSP(new Vec3D(baseRound / -2, 0.0, baseRound / -2) ,new Vec3D(baseRound / 2, 2.0 ,baseRound / 2));
    
    // create base position
    
    for (i = 0;i < 16;i++) {
        x[i] = Math.sin(0.125*Math.PI*-i) * baseRound / 2;
        y[i] = 0;
        z[i] = Math.cos(0.125*Math.PI*-i) * baseRound / 2;
    }
    
    // setting
    
    var depthStarP = (1-depthTable) / 3 * 2;
    var depthLowerP = (1-depthTable) / 3 * -1.5;
    var depthCulet = 0.02;
    
    //print('depthSP:'+depthStarP);
    //print('depthLP:'+depthLowerP);
    
    // create table
    
    for (i = 0;i < 8;i++) {
        var index = 1 + i*2;
        tableVerts[i] = new Vec3D(x[index] * depthTable, baseRound * depth, z[index] * depthTable);
    }
    
    core.addPolygon(8,true,tableVerts);
    
    // create star facets
    
    //print(x[12]);
    var svT = (baseRound * depth - baseRound * depthPavilion ) / (x[12]*depthTable - x[12]);
    var svD = ((baseRound * depth + baseRound * depthPavilion) - svT * (x[12] * depthTable + x[12]) ) / 2;
    var starVertsY = x[12] * (depthTable + depthStarP) * svT + svD;
    
    //print(baseRound*depth);
    //print(svT);
    //print(svD);
    //print(starVertsY);
    
    for (i = 0;i < 8;i++) {
        var index;
        starVerts[i] = new Array;
        
        if (i == 7) {
            starVerts[i][0] = tableVerts[0];
            index = 0;
        } else {
            starVerts[i][0] = tableVerts[i+1];
            index = (i+1)*2;
        }
        starVerts[i][1] = tableVerts[i];
        starVerts[i][2] = new Vec3D(x[index] * (depthTable + depthStarP), starVertsY, z[index] * (depthTable + depthStarP));
        
        core.addPolygon(3, true,starVerts[i]);
    }
    
    // create bezel facets
    
    for (i = 0;i < 8;i++) {
        var index = 1 + i * 2;
        bezelVerts[i] = new Array;
        
        bezelVerts[i][3] = tableVerts[i];
        bezelVerts[i][2] = starVerts[i][2];
        bezelVerts[i][1] = new Vec3D(x[index], baseRound * (depthPavilion), z[index]);
        if (i==0) {
            bezelVerts[i][0] = starVerts[7][2];
        } else {
            bezelVerts[i][0] = starVerts[i-1][2];
        }
        //print(bezelVerts[i]);
        core.addPolygon(4,true,bezelVerts[i]);
    }
    //
    
    for (i = 0;i < 8;i++) {
        var index = i * 2;
        var facet_index;
        
        facet_index = i;
        edgeVerts[i] = new Array;
        edgeVerts[i][0] = bezelVerts[facet_index][1];
        edgeVerts[i][1] = bezelVerts[facet_index][0];
        edgeVerts[i][2] = new Vec3D(x[index],baseRound*(depthPavilion),z[index]);
    
        core.addPolygon(3,true,edgeVerts[i]);
        
        if (i == 0) {
            facet_index = 7;
        } else {
            facet_index = i - 1;
        }
        edgeVerts[i+8] = new Array;
        edgeVerts[i+8][0] = bezelVerts[facet_index][2];
        edgeVerts[i+8][1] = bezelVerts[facet_index][1];
        edgeVerts[i+8][2] = new Vec3D(x[index],baseRound*(depthPavilion),z[index]);
        
        core.addPolygon(3,true,edgeVerts[i+8]);
    }
    
    //
    
    if (depthGirdle > 0) {
    for (i = 0;i < 8;i++) {
        var index = i*2;
        var girdleVerts = new Array;
        
        girdleVerts[3] = edgeVerts[i][0];
        girdleVerts[2] = edgeVerts[i][0].add(new Vec3D(0, -baseRound*depthGirdle, 0));
        girdleVerts[1] = edgeVerts[i][2].add(new Vec3D(0, -baseRound*depthGirdle, 0));
        girdleVerts[0] = edgeVerts[i][2];
        
        edgeVerts[i][0] = girdleVerts[2];
        edgeVerts[i][2] = girdleVerts[1];
        
        core.addPolygon(4,true,girdleVerts);
        
        girdleVerts[0] = edgeVerts[i+8][1];
        girdleVerts[1] = edgeVerts[i+8][1].add(new Vec3D(0, -baseRound*depthGirdle, 0));
        girdleVerts[2] = edgeVerts[i+8][2].add(new Vec3D(0, -baseRound*depthGirdle, 0));
        girdleVerts[3] = edgeVerts[i+8][2];
        
        edgeVerts[i+8][1] = girdleVerts[1];
        edgeVerts[i+8][2] = girdleVerts[2];
        
        core.addPolygon(4,true,girdleVerts);   
    }
    }
    //
        
    var lvT = baseRound * depthPavilion / x[12];
    var depthLower = depthTable + depthLowerP;
    var lowerVertsY = lvT * x[12] * depthLower;
    
    var culetVertsY = lvT * x[12] * depthCulet;
    
    /*
    print("----");
    print(lvT);
    print(depthLower);
    print(lowerVertsY);
    */
    
    for (i = 0;i < 8;i++) {
        var index =  i*2;
                
        lowerVerts[i] = new Array;
        lowerVerts[i][0] = edgeVerts[i][0];
        lowerVerts[i][1] = edgeVerts[i][2];
        lowerVerts[i][2] = new Vec3D(x[index]*(depthLower),lowerVertsY,z[index]*(depthLower));
        
        core.addPolygon(3,true,lowerVerts[i]);
        
        lowerVerts[i+8] = new Array;
        index = i*2;
        if (index < 0) {
            index = index + 16;
        }
        lowerVerts[i+8][0] = edgeVerts[i+8][2];
        lowerVerts[i+8][1] = edgeVerts[i+8][1];
        lowerVerts[i+8][2] = new Vec3D(x[index]*(depthLower),lowerVertsY,z[index]*(depthLower));
        
        core.addPolygon(3,true,lowerVerts[i+8]);
      }
     
     // main
     
     if (culetFace) {
        for (i = 0;i < 8;i++) {
            var index = i+9;
            if (index > 15) {
                index = index - 16;
            }
            var culetI = i*2;
            var culetJ = culetI + 2;
            if (culetJ > 15) {
                culetJ = culetJ - 16;
            }
           mainVerts[i] = new Array;
            mainVerts[i][0] = lowerVerts[i][0];
            mainVerts[i][1] = lowerVerts[i][2];
            mainVerts[i][2] = new Vec3D(x[culetI] * depthCulet, culetVertsY, z[culetI] * depthCulet);
            mainVerts[i][3] = new Vec3D(x[culetJ] * depthCulet, culetVertsY, z[culetJ] * depthCulet);
            mainVerts[i][4] = lowerVerts[index][2];
            
            core.addPolygon(5,true,mainVerts[i]);
        }
        var culetVerts = new Array;
        for (i = 0;i < 8;i++) {
            culetVerts[i] = mainVerts[7-i][2];
        }
        core.addPolygon(8,true,culetVerts);
     } else {
        for (i = 0;i < 8;i++) {
        var index = i+9;
        if (index > 15) {
            index = index - 16;
        }
        mainVerts[i] = new Array;
        mainVerts[i][0] = lowerVerts[i][0];
        mainVerts[i][1] = lowerVerts[i][2];
        mainVerts[i][2] = new Vec3D(0, 0, 0);
        mainVerts[i][3] = lowerVerts[index][2];
        
        core.addPolygon(4,true,mainVerts[i]);
        }
    }
    
    core.destroyVertexBSP();
}



